// Gemini conversation extractor
function extractGeminiConversation() {
  console.log("[v0] Extracting Gemini conversation")

  const title = "Gemini Conversation"

  // Extract messages
  const messages = []
  const messageElements = document.querySelectorAll('[class*="message"], [class*="query"], [class*="response"]')

  messageElements.forEach((element) => {
    const content = element.textContent.trim()
    if (content) {
      messages.push({
        role: element.classList.contains("query") ? "user" : "assistant",
        content: content,
      })
    }
  })

  const content = messages.map((msg) => `${msg.role.toUpperCase()}: ${msg.content}`).join("\n\n")

  return {
    success: true,
    title: title,
    content: content,
    tags: ["gemini"],
  }
}

window.chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  // Handle ping request (used to check if content script is loaded)
  if (request.action === "ping") {
    sendResponse({ success: true, platform: "gemini" })
    return true
  }
  
  if (request.action === "extractConversation") {
    try {
      const result = extractGeminiConversation()
      sendResponse(result)
    } catch (error) {
      console.error("[Zdravo AI] Error extracting conversation:", error)
      sendResponse({ success: false, error: error.message })
    }
  }
  return true
})
