// Claude conversation extractor
function extractClaudeConversation() {
  console.log("[v0] Extracting Claude conversation")

  // Get conversation title
  const titleElement = document.querySelector("h1, [role='heading']")
  const title = titleElement ? titleElement.textContent.trim() : "Untitled Claude Conversation"

  // Extract all messages
  const messages = []
  const messageElements = document.querySelectorAll('[data-is-streaming], [class*="message"]')

  messageElements.forEach((element) => {
    const isUser = element.textContent.includes("You") || element.classList.contains("user")
    const content = element.textContent.trim()

    if (content) {
      messages.push({
        role: isUser ? "user" : "assistant",
        content: content,
      })
    }
  })

  const content = messages.map((msg) => `${msg.role.toUpperCase()}: ${msg.content}`).join("\n\n")

  return {
    success: true,
    title: title,
    content: content,
    tags: ["claude"],
  }
}

window.chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  // Handle ping request (used to check if content script is loaded)
  if (request.action === "ping") {
    sendResponse({ success: true, platform: "claude" })
    return true
  }
  
  if (request.action === "extractConversation") {
    try {
      const result = extractClaudeConversation()
      sendResponse(result)
    } catch (error) {
      console.error("[Zdravo AI] Error extracting conversation:", error)
      sendResponse({ success: false, error: error.message })
    }
  }
  return true
})
